from .BYOL import BYOL
from .MSR import MSR


METHOD_LIST = ["byol", "msr"]


def create_method(args):
    assert args.method in METHOD_LIST

    if args.method == 'byol':
        model = BYOL(args.arch, args.max_step)
    elif args.method == 'msr':
        model = MSR(args.arch, max_step=args.max_step, beta=args.beta)

    return model
